<?xml version="1.0" ?> 
<!-- Copyright 2002 Geac Canada Limited                           -->
<!-- created for Geac Geos2 product on January 25,2002.           -->

<!-- This version is specially used for outside user with         -->
<!-- different database name                                      -->
<!-- Advance.xsl                                                  -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0" />

<xsl:template match="/CitationList">
    <html>
        <head></head>
        <body>
            <xsl:apply-templates select="MoreList" mode="FirstSet"/>
            <div align="left" style="font-family:Arial Unicode MS; font-size:12pt; background=lightyellow">
                <xsl:apply-templates select="Total" />
                <p style="border-style:solid; border-width: 5px; border-color:#0000ff">
                    <table width="100%">
                        <thead style="height:20; align:center; background-color:silver">
                            <tr>
			        <th width="2%"></th>
				<th width="10%">Creator</th>
				<th width="20%">Title</th>
				<th width="15%">URL</th>
				<th width="25%"><span style="color:blue">(Available/Owned)</span>&#160;&#160;Location</th>
				<th width="5%">Date</th>
		            </tr>
                        </thead>
                        <xsl:apply-templates select="List" />
                    </table>
                </p>
                <xsl:apply-templates select="Total" />
            </div>
            <xsl:apply-templates select="MoreList" mode="SecondSet" />
        </body>
    </html>
</xsl:template>

<xsl:template match="Total">
    <p>
        <b>
        <xsl:text>Displayed:&#160;</xsl:text><xsl:value-of select="@From" />
        <xsl:text>&#160;-&#160;</xsl:text><xsl:value-of select="@To" />
        <xsl:text>&#160;of&#160;</xsl:text><xsl:value-of select="." />
        </b>
    </p>
</xsl:template>

<xsl:template match="List">
    <tbody>
        <tr >
            <td align="left" valign="top">
                <span style="color:black">
                    <b><xsl:value-of select="@SeqNum" /></b>
                </span>
            </td>
            <xsl:choose>
                <xsl:when test="@ErrMsg">
                    <td align="left" colspan="4">
                        <span style="color:red; font-family:Arial Unicode MS; font-size:12pt">
                            <b><xsl:value-of select="@ErrMsg" /></b>
                        </span>
                    </td>
                </xsl:when>
                <xsl:otherwise>
                    <td align="left" valign="top">
                        <xsl:apply-templates select=".//Creator" />
                    </td>
                    <td align="left" valign="top">
                        <xsl:apply-templates select=".//Title">
                            <xsl:with-param name="objectnum" select="@ObjNum" />
                        </xsl:apply-templates>
                    </td>
                    <td align="left" valign="top">
                        <xsl:apply-templates select=".//URI" />
                    </td>
                    <td align="left" valign="top">
                        <xsl:apply-templates select=".//CitHoldings" />
                        <xsl:apply-templates select=".//HeldBy" />            
                    </td>
                    <td align="left" valign="top">
                        <xsl:apply-templates select=".//Year" />
                    </td>
                </xsl:otherwise>
            </xsl:choose>
        </tr>
        <tr><td>&#160;</td><td>&#160;</td><td>&#160;</td><td>&#160;</td><td>&#160;</td><td>&#160;</td></tr>
    </tbody>
</xsl:template>

<xsl:template match="Creator">
    <span style="color:black">
        <b><xsl:value-of select="." /></b><br/>
    </span>                             
</xsl:template>

<xsl:template match="Title">
    <xsl:param name="objectnum" />
    <xsl:element name="a">
        <xsl:attribute name="href">#<xsl:value-of select="$objectnum" /></xsl:attribute>
        <xsl:attribute name="title">Click to select</xsl:attribute>
        <span style="color:blue">
            <b><xsl:value-of select="." /></b><br/>
        </span>
    </xsl:element>
</xsl:template>

<xsl:template match="URI">
    <xsl:if test="not(@DisplayLevel)" >

    <xsl:element name="a">
        <xsl:attribute name="href">#URL|<xsl:value-of select="." /></xsl:attribute>
	<xsl:attribute name="title">Click to select</xsl:attribute>
	<xsl:choose>
	    <xsl:when test="@Linktext">
                <span style="color:blue"><b><xsl:value-of select="@Linktext"/></b><br/><br/></span>
	    </xsl:when>
	    <xsl:otherwise>
	        <span style="color:blue"><b><xsl:value-of select="."/></b><br/></span>
	    </xsl:otherwise>
	</xsl:choose>
    </xsl:element>
    
    </xsl:if>
</xsl:template>

<xsl:template match="CitHoldings">
    <table>
        <xsl:for-each select="CitHoldingsByLoc">
            <tr>
	        <td align="left" valign="top">
                    <span style="color:blue">
                        <b><xsl:text>(</xsl:text><xsl:value-of select="CitHoldingAvailOwnCnt" /><xsl:text>)</xsl:text></b>
                    </span>
                </td>
                <xsl:for-each select="CitLocation">
                    <td align="left" valign="top">
		        <span style="color:black">
		    	    <b>	
		    	        <xsl:value-of select="normalize-space(concat(@CitCallNumber, ' ',@CitInstitution, ' ',@CitSublocation,' ',@CitCollection))" />
		    	    </b><br/>
		    	</span>
		    </td>
		</xsl:for-each>
             </tr>
         </xsl:for-each>
     </table>
</xsl:template>

<xsl:template match="HeldBy">
    <table>
        <xsl:for-each select="HeldLocation">
            <tr>
	        <td align="left" valign="top">
                    <span style="color:black">
                        <b><xsl:value-of select="." /></b>
                    </span>
                </td>  
            </tr>
        </xsl:for-each>
    </table>
</xsl:template>

<xsl:template match="Year">
    <span style="color:black">
        <b><xsl:value-of select="." /></b>
    </span>
</xsl:template>

<xsl:template match="MoreList" mode="FirstSet">
    <xsl:if test="@Previous">
        <input type="button" name="previous_top" value="Previous " />
        <xsl:text>&#160;</xsl:text>
    </xsl:if>
    <input type="text" name="jumpnum_top" size="4" />
    <input type="button" name="jumpto_top" value="Jump to #" />
    <xsl:text>&#160;</xsl:text>
    <xsl:if test="@Next">
        <input type="button" name="next_top" value="  Next   " />
    </xsl:if>
</xsl:template>

<xsl:template match="MoreList" mode="SecondSet">
    <xsl:if test="@Previous">
        <input type="button" name="previous_bottom" value="Previous " />
        <xsl:text>&#160;</xsl:text>
    </xsl:if>
    <input type="text" name="jumpnum_bottom" size="4" />
    <input type="button" name="jumpto_bottom" value="Jump to #" />
    <xsl:text>&#160;</xsl:text>
    <xsl:if test="@Next">
        <input type="button" name="next_bottom" value="  Next   " />
    </xsl:if>
</xsl:template>

</xsl:stylesheet>