<?xml version="1.0" ?> 
<!-- Copyright 2002 Geac Canada Limited                           -->
<!-- created for Geac Geos2 product on January 25,2002.           -->

<!-- This version is specially used for outside user with         -->
<!-- different database name                                      -->
<!-- Advance_row.xsl                                              -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0" />

<xsl:template match="/CitationList">
    <html>
        <head></head>
        <body>
            <xsl:apply-templates select="MoreList" mode="FirstSet"/>
            <div align="left" style="font-family:Arial Unicode MS; font-size:12pt; background=lightyellow">
                <xsl:apply-templates select="Total" />
                <p style="border-style:solid; border-width: 5px; border-color:#0000ff">
                    <table>
                        <xsl:apply-templates select="List" />
                    </table>
                </p>
                <xsl:apply-templates select="Total" />
            </div>
            <xsl:apply-templates select="MoreList" mode="SecondSet" />
        </body>
    </html>
</xsl:template>

<xsl:template match="Total">
    <p>
        <b>
        <xsl:text>Displayed:&#160;</xsl:text><xsl:value-of select="@From" />
        <xsl:text>&#160;-&#160;</xsl:text><xsl:value-of select="@To" />
        <xsl:text>&#160;of&#160;</xsl:text><xsl:value-of select="." />
        </b>
    </p>
</xsl:template>

<xsl:template match="List">
    <xsl:choose>
        <xsl:when test="@ErrMsg">
            <tr>
                <td align="left" valign="top">
                    <span style="color:black">
                        <b><xsl:value-of select="@SeqNum" /></b>
                    </span>
                </td>
                <td align="left" colspan="2">
                    <span style="color:red; font-family:Arial Unicode MS; font-size:12pt">
                        <b><xsl:value-of select="@ErrMsg" /></b>
                    </span>
                </td>
            </tr>
        </xsl:when>
        <xsl:otherwise>
            <xsl:apply-templates select=".//Creator">
                <xsl:with-param name="sequence" select="@SeqNum" />
            </xsl:apply-templates>
            <xsl:choose>
                <xsl:when test=".//Creator">
                    <xsl:apply-templates select=".//Title">
                        <xsl:with-param name="objectnum" select="@ObjNum" />
                        <xsl:with-param name="sequence" select="0" />
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select=".//Title">
                        <xsl:with-param name="objectnum" select="@ObjNum" />
                        <xsl:with-param name="sequence" select="@SeqNum" />
                    </xsl:apply-templates>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:apply-templates select=".//Year" />
            <xsl:apply-templates select=".//URI" />
            <xsl:apply-templates select=".//CitHoldings" />
            <xsl:apply-templates select=".//HeldBy" />
        </xsl:otherwise>
    </xsl:choose>       
    <tr><td>&#160;</td><td>&#160;</td><td>&#160;</td></tr>
</xsl:template>

<xsl:template match="Creator">
    <xsl:param name="sequence" />
    <tr>
        <td align="left" valign="top">
            <span style="color:black">
                <b><xsl:value-of select="$sequence" /></b>
            </span>
        </td>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Creator :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>                             
        </td>
    </tr>
</xsl:template>

<xsl:template match="Title">
    <xsl:param name="objectnum" />
    <xsl:param name="sequence" />
    <tr>
        <xsl:choose>
            <xsl:when test="$sequence='0'">
                <td>&#160;</td>
            </xsl:when>
            <xsl:otherwise>
                <td align="left" valign="top">
                    <span style="color:black">
                        <b><xsl:value-of select="$sequence" /></b>
                    </span>
                </td>
            </xsl:otherwise>
        </xsl:choose>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Title :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <xsl:element name="a">
            <xsl:attribute name="href">#<xsl:value-of select="$objectnum" /></xsl:attribute>
            <xsl:attribute name="title">Click to select</xsl:attribute>
            <span style="color:blue">
                <b><xsl:value-of select="." /></b>
            </span>
            </xsl:element>
        </td>
    </tr>
</xsl:template>

<xsl:template match="URI">
    <xsl:if test="not(@DisplayLevel)" >
        <tr>
            <td>&#160;</td>
            <td align="left" valign="top">
                <span style="color:magenta">
                    <b><xsl:text>URL :</xsl:text></b>
                </span>
            </td>
            <td align="left">
                <xsl:element name="a">
                    <xsl:attribute name="href">#URL|<xsl:value-of select="." /></xsl:attribute>
	            <xsl:attribute name="title">Click to select</xsl:attribute>
	            <xsl:choose>
	                <xsl:when test="@Linktext">
                            <span style="color:blue"><b><xsl:value-of select="@Linktext"/></b></span>
	                </xsl:when>
	                <xsl:otherwise>
	                    <span style="color:blue"><b><xsl:value-of select="."/></b></span>
	                </xsl:otherwise>
	            </xsl:choose>
                </xsl:element>
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template match="CitHoldings">
    <tr>
        <td>&#160;</td>
        <td align="left" valign="top">
            <span style="color:magenta">
<!--                <b><xsl:text>Citation&#160;Holdings :</xsl:text></b> -->
               <b><xsl:text>Holdings :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <xsl:for-each select="CitHoldingsByLoc">	    
                <span style="color:blue">
                    <b><xsl:text>(</xsl:text><xsl:value-of select="CitHoldingAvailOwnCnt" /><xsl:text>)&#160;</xsl:text></b>
                </span>
                <xsl:for-each select="CitLocation">           
		    <span style="color:black">
		        <b>	
		    	    <xsl:value-of select="normalize-space(concat(@CitCallNumber, ' ',@CitInstitution, ' ',@CitSublocation,' ',@CitCollection))" />
		    	</b><br/>
		    </span>
		</xsl:for-each>         
            </xsl:for-each>
        </td>
    </tr>
</xsl:template>

<xsl:template match="HeldBy">
    <tr>
        <td>&#160;</td>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Held Locations :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <xsl:for-each select="HeldLocation">	        
                <span style="color:black">
                    <b><xsl:value-of select="." /></b>
                </span>
            </xsl:for-each>
        </td>
    </tr>
</xsl:template>

<xsl:template match="Year">
    <tr>
        <td>&#160;</td>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Date :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>
        </td>
    </tr>
</xsl:template>

<xsl:template match="MoreList" mode="FirstSet">
    <xsl:if test="@Previous">
        <input type="button" name="previous_top" value="Previous " />
        <xsl:text>&#160;</xsl:text>
    </xsl:if>
    <input type="text" name="jumpnum_top" size="4" />
    <input type="button" name="jumpto_top" value="Jump to #" />
    <xsl:text>&#160;</xsl:text>
    <xsl:if test="@Next">
        <input type="button" name="next_top" value="  Next   " />
    </xsl:if>
</xsl:template>

<xsl:template match="MoreList" mode="SecondSet">
    <xsl:if test="@Previous">
        <input type="button" name="previous_bottom" value="Previous " />
        <xsl:text>&#160;</xsl:text>
    </xsl:if>
    <input type="text" name="jumpnum_bottom" size="4" />
    <input type="button" name="jumpto_bottom" value="Jump to #" />
    <xsl:text>&#160;</xsl:text>
    <xsl:if test="@Next">
        <input type="button" name="next_bottom" value="  Next   " />
    </xsl:if>
</xsl:template>

</xsl:stylesheet>