<?xml version="1.0" ?>
<!-- Copyright 2002 Geac Canada Limited                           -->
<!-- created for Geac Geos2 product on March 11, 2002.            -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0" />
<xsl:template match="SearchResults">
    <html>
        <head>
        	<h3>
           <xsl:apply-templates select="Resource/InvoiceDataDisplay" />
          </h3>
        </head>
        <body>
            <div>
                <table style="font-family:Arial Unicode MS; font-size:14" cols="6">
                    <xsl:apply-templates select="Resource/InvoiceDataDisplay/InvoiceDetails" />
								</table>
            </div> 

        </body>
    </html>
</xsl:template>
<xsl:template match="Resource/InvoiceDataDisplay">
    <xsl:apply-templates select="InvoiceTitle" />
</xsl:template>    
<xsl:template match="Resource/InvoiceDataDisplay/InvoiceDetails">
    <xsl:apply-templates select="InvoiceNumber" />
    <xsl:apply-templates select="InvoiceCurrencyCode" />
    <xsl:apply-templates select="Library" />
    
    <xsl:apply-templates select="InvoiceType" />
    <xsl:apply-templates select="PaymentCurrencyCode" />
    <xsl:apply-templates select="PayMethod" />

    <xsl:apply-templates select="VendorId" />
    <xsl:apply-templates select="VendorName" />

    <xsl:apply-templates select="InvoiceStatus" />

    <xsl:apply-templates select="HeaderInvoiced" />
    <xsl:apply-templates select="HeaderBase" />
    <xsl:apply-templates select="NumberDetailLines" />
    
    <xsl:apply-templates select="Gross" />
    <xsl:apply-templates select="GrossBase" />

<!-- 
    <xsl:apply-templates select="DiscountAmount" />
    <xsl:apply-templates select="DiscountBase" />
    <xsl:apply-templates select="DiscountProrateMethod" />
    <xsl:apply-templates select="DiscountPercent" />

    <xsl:apply-templates select="RegularCharges" />
    <xsl:apply-templates select="RegularChargesBase" />
    <xsl:apply-templates select="RegularChargesProrateMethod" />

    <xsl:apply-templates select="SpecialCharges" />
    <xsl:apply-templates select="SpecialChargesBase" />

    <xsl:apply-templates select="Tax" />
    <xsl:apply-templates select="TaxBase" />
    <xsl:apply-templates select="TaxProrateMethod" />

    <xsl:apply-templates select="OtherCharges" />
    <xsl:apply-templates select="OtherChargesBase" />
    <xsl:apply-templates select="OtherChargesProrateMethod" />
 -->

    <xsl:apply-templates select="Net" />
    <xsl:apply-templates select="NetBase" />

    <xsl:apply-templates select="Paid" />
    <xsl:apply-templates select="PaidBase" />

    <xsl:apply-templates select="Balance" />
    <xsl:apply-templates select="BalanceBase" />
    <xsl:apply-templates select="DueDate" />

    <xsl:apply-templates select="EnteredBy" />
    <xsl:apply-templates select="EnteredDate" />
    <xsl:apply-templates select="ReceivedDate" />

    <xsl:apply-templates select="EditedBy" />
    <xsl:apply-templates select="EditedDate" />
    <xsl:apply-templates select="ProductionDate" />

    <xsl:apply-templates select="AuthorizedBy" />
    <xsl:apply-templates select="AuthorizedDate" />
    <xsl:apply-templates select="DocumentDate" />


    <xsl:apply-templates select="Note" />

    <xsl:apply-templates select="DiscountNote" />
</xsl:template>

<xsl:template match="InvoiceTitle">
    <xsl:value-of select="." />
</xsl:template>
<!-- Invoice templates  -->
   <xsl:template match="InvoiceNumber">
        <tr></tr> 
        <th width="20%" align="left" valign="top">
		      <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
   </xsl:template>
   <xsl:template match="InvoiceCurrencyCode">
        <th width="20%" align="left" valign="top">
		      <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
   </xsl:template>
   <xsl:template match="Library">
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>

   <xsl:template match="InvoiceType">
        <tr></tr> 
        <th width="20%" align="left" valign="top">
		      <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="PaymentCurrencyCode">
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
   </xsl:template>
   <xsl:template match="PayMethod">
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>

   <xsl:template match="VendorId">
        <tr></tr> 
        <th width="20%" align="left" valign="top">
		    	<xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="VendorName">
        <td colspan="5" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
   </xsl:template>
   
   <xsl:template match="InvoiceStatus">
        <tr></tr> 
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>

   <xsl:template match="HeaderInvoiced">
        <tr></tr> 
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Space" />
        </th>
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />    
        </th>
   </xsl:template>
   <xsl:template match="HeaderBase">
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />    
        </th>
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Space" />    
        </th>
   </xsl:template>
   <xsl:template match="NumberDetailLines">
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>

   <xsl:template match="Gross">
        <tr></tr> 
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="GrossBase">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="DueDate">
        <th width="20%" align="left" valign="top">
		      <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
   </xsl:template>

   <xsl:template match="Net">
        <tr></tr> 
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="NetBase">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="ReceivedDate">
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>

   <xsl:template match="Paid">
        <tr></tr> 
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="PaidBase">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="ProductionDate">
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>

   <xsl:template match="Balance">
        <tr></tr> 
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="BalanceBase">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="DocumentDate">
        <th width="20%" align="left" valign="top">
		      <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
   </xsl:template>

   <xsl:template match="EnteredBy">
        <tr></tr> 
        <th width="20%" align="left" valign="top">
		      <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
   </xsl:template>
   <xsl:template match="EnteredDate">
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
   </xsl:template>

   <xsl:template match="EditedBy">
        <tr></tr> 
        <th width="15%" align="left" valign="top">
		      <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
   </xsl:template>
   <xsl:template match="EditedDate">
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
   </xsl:template>

   <xsl:template match="AuthorizedBy">
        <tr></tr> 
        <th width="15%" align="left" valign="top">
		      <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
   </xsl:template>
   <xsl:template match="AuthorizedDate">
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
   </xsl:template>

   <xsl:template match="DiscountAmount">
        <tr></tr> 
        <th width="15%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>

   <xsl:template match="DiscountBase">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="DiscountPercent">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="DiscountProrateMethod">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   
   <xsl:template match="RegularCharges">
        <tr></tr> 
        <th width="15%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="RegularChargesBase">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="RegularChargesProrateMethod">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>

   <xsl:template match="SpecialCharges">
        <tr></tr> 
        <th width="15%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="SpecialChargesBase">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>

   <xsl:template match="Tax">
        <tr></tr> 
        <th width="15%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="TaxBase">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="TaxProrateMethod">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>

   <xsl:template match="OtherCharges">
        <tr></tr> 
        <th width="15%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="OtherChargesBase">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
   <xsl:template match="OtherChargesProrateMethod">
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>

   <xsl:template match="Note">
        <tr></tr> 
        <th width="15%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>

   <xsl:template match="DiscountNote">
        <tr></tr> 
        <th width="15%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
   </xsl:template>
</xsl:stylesheet>