<?xml version="1.0" ?>
<!-- Copyright 2001 Geac Canada Limited                           -->
<!-- created for Geac Geos2 product on December 20, 2001.         -->
<!--                  last modified on January 8, 2002.           -->
<!-- 
     this version is completely different from the generic version
     first released for a generalized display of an XML record.
     This version includes brief holdings information.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0" />

<xsl:template match="SearchResults">
    <html>
        <head>
        	<h3>
           <xsl:apply-templates select="Resource/OrderDataDisplay/OrderDetails" />
          </h3>
        </head>
        <body>
            <div>
                <table style="font-family:Arial Unicode MS; font-size:14" cols="6">
								    <xsl:apply-templates select="Resource/OrderDataDisplay/OrderDetails/PartTwo" />
                    <xsl:apply-templates select="Resource/OrderDataDisplay/OrderDetails/PartOne" />
								</table>
            </div> 

            <div>
						   	<xsl:apply-templates select="Resource/OrderDataDisplay/OrderAllocation" />
            </div>
        </body>
    </html>
</xsl:template>
<xsl:template match="Resource/OrderDataDisplay/OrderDetails">
    <xsl:apply-templates select="OrderTitle" />
</xsl:template>    
<xsl:template match="Resource/OrderDataDisplay/OrderDetails/PartOne">
    <xsl:apply-templates select="IsbnIssn" />
    <xsl:apply-templates select="LCCardNo" />
    <xsl:apply-templates select="VendorTitleNo" />
    <xsl:apply-templates select="Format" />
    <xsl:apply-templates select="SubjectCode" />
    <xsl:apply-templates select="SortCode" />
    <xsl:apply-templates select="Library" />
    <xsl:apply-templates select="OrderType" />

    <xsl:apply-templates select="RequestDate" />
    <xsl:apply-templates select="POLine" />
    <xsl:apply-templates select="Vendor" />
    <xsl:apply-templates select="DeliveryDate" />
    <xsl:apply-templates select="RequestNo" />
    <xsl:apply-templates select="Condition" />
    <xsl:apply-templates select="OrderDate" />
    <xsl:apply-templates select="OrderCopy" />
    <xsl:apply-templates select="ReceivedCopy" />
    <xsl:apply-templates select="Selector" />
</xsl:template>
<xsl:template match="Resource/OrderDataDisplay/OrderDetails/PartTwo">
    <xsl:apply-templates select="Title" />
    <xsl:apply-templates select="Author" />
    <xsl:apply-templates select="ExtraBib1" />
    <xsl:apply-templates select="ExtraBib2" />
    <xsl:apply-templates select="ExtraBib3" />
    <xsl:apply-templates select="ExtraBib4" />
    <xsl:apply-templates select="ExtraBib5" />
    <xsl:apply-templates select="ExtraBib6" />
    <xsl:apply-templates select="ExtraBib7" />
    <xsl:apply-templates select="ExtraBib8" />
    <xsl:apply-templates select="ExtraBib9" />
    <xsl:apply-templates select="ExtraBib10" />
</xsl:template>

<xsl:template match="OrderTitle">
    <xsl:value-of select="." />
</xsl:template>
<!-- Order Part One Section  templates  -->
<xsl:template match="IsbnIssn">
        <tr></tr> 
        <th width="20%" align="left" valign="top">
		      <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
</xsl:template>
<xsl:template match="LCCardNo">
        <th width="15%" align="left" valign="top">
		      <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />    
        </td>
</xsl:template>
<xsl:template match="VendorTitleNo">
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />    
        </td>
</xsl:template>
<xsl:template match="Format">
        <tr></tr> 
        <th width="15%" align="left" valign="top">
		    	<xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />    
        </td>
</xsl:template>
<xsl:template match="SubjectCode">
        <th width="20%" align="left" valign="top">
		      <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
</xsl:template>
<xsl:template match="SortCode">
        <th width="15%" align="left" valign="top">
		       <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />
        </td>
</xsl:template>
<xsl:template match="Library">
        <tr></tr>
        <th width="20%" align="left" valign="top">
          <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />    
        </td>
</xsl:template><xsl:template match="OrderType">
        <th width="20%" align="left" valign="top">
          <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
          <xsl:value-of select="." />    
        </td>
</xsl:template>
<xsl:template match="RequestDate">
        <th width="20%" align="left" valign="top">
		       <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />
        </td>
</xsl:template>
<xsl:template match="POLine">
				<tr></tr>
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
           <xsl:value-of select="." />
        </td>
</xsl:template>
<xsl:template match="Vendor">
        <th width="15%" align="left" valign="top">
						<xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
            <xsl:value-of select="." />
        </td>
</xsl:template>
<xsl:template match="OrderDate">
        <th width="20%" align="left" valign="top">
						<xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
            <xsl:value-of select="." />
        </td>
</xsl:template>
<xsl:template match="RequestNo">
				<tr></tr>
        <th width="20%" align="left" valign="top">
						<xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
            <xsl:value-of select="." />
        </td>
</xsl:template>
<xsl:template match="Condition">
        <th width="15%" align="left" valign="top">
						<xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
            <xsl:value-of select="." />
        </td>
</xsl:template>
<xsl:template match="DeliveryDate">
        <th width="20%" align="left" valign="top">
						<xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
            <xsl:value-of select="." />
        </td>
</xsl:template>
<xsl:template match="OrderCopy">
        <tr></tr>
        <th width="20%" align="left" valign="top">
						<xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
            <xsl:value-of select="." />
        </td>
</xsl:template>
<xsl:template match="ReceivedCopy">
        <th width="20%" align="left" valign="top">
						<xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
            <xsl:value-of select="." />
        </td>
</xsl:template>
<xsl:template match="Selector">
        <th width="20%" align="left" valign="top">
						<xsl:value-of select="@Label" />
        </th>
        <td width="15%" align="left" valign="top">
            <xsl:value-of select="." />
        </td>
</xsl:template>
<!-- Order Part Two Section  templates  -->
<xsl:template match="Title">
    <tr>
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>
<xsl:template match="Author">
    <tr>
        <th width="20%" align="left" valign="top">
          <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="ExtraBib1">
    <tr>
        <th width="20%" align="left" valign="top">
		      <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>
<xsl:template match="ExtraBib2">
    <tr>
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>
<xsl:template match="ExtraBib3">
    <tr>
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
           <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>
<xsl:template match="ExtraBib4">
    <tr>
        <th width="20%" align="left" valign="top">
          <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
          <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>
<xsl:template match="ExtraBib5">
    <tr>
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
           <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>
<xsl:template match="ExtraBib6">
    <tr>
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
           <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>
<xsl:template match="ExtraBib7">
    <tr>
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
           <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>
<xsl:template match="ExtraBib8">
    <tr>
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
           <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>
<xsl:template match="ExtraBib9">
    <tr>
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
           <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>
<xsl:template match="ExtraBib10">
    <tr>
        <th width="20%" align="left" valign="top">
           <xsl:value-of select="@Label" />
        </th>
        <td colspan="5" align="left" valign="top">
           <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>
<xsl:template match="Resource/OrderDataDisplay/OrderAllocation">
    <br /><hr />
    <table width="100%" border="2" style="font-family:Arial Unicode MS; font-size:14">
        <thead style="height:20; align:left; background-color:silver">
       	    <xsl:choose>
	       	    <xsl:when test=".//AllocType='PERCENT'">
				        <tr>
									<th colspan="3" width="33%">
			          		<xsl:value-of select=".//AllocLoc/@Label" />
			          	</th>
									<th colspan="2" width="33%">
			        	  	<xsl:value-of select=".//AllocFund/@Label" />
									</th>
									<th colspan="2" width="33%">						
				            <xsl:value-of select=".//AllocTrkFund/@Label" />
			    	  		</th>
				       	</tr> 
				       	<tr> 
					       	<th width="10%">
					          <xsl:value-of select=".//AllocLoc/AllocLabel1" />
					        </th>
					      	<th width="10%">
			  	       	 <xsl:value-of select=".//AllocLoc/AllocLabel2" />
			  	 		    </th>
			  	 		    <th width="10%">
						       <xsl:value-of select=".//AllocLoc/AllocLabel3" />
			  	 		    </th>          	
					        <th width="30%">
					           <xsl:value-of select=".//AllocFund/AllocLabel4" />
					        </th>
					       	<th width="10%">
					       		 <xsl:value-of select=".//AllocFund/AllocLabel5" />
			  	     		</th>
		    	        <th width="30%">
								   <xsl:value-of select=".//AllocTrkFund/AllocLabel6" />
			  		      </th>
		    	 	      <th width="10%">
								   <xsl:value-of select=".//AllocTrkFund/AllocLabel7" />
			  	   			</th>
		  	   			</tr>
	  	   		</xsl:when>
	  	   		<xsl:otherwise>
	  	   		        <tr>
												<th colspan="3" width="33%">
						          		<xsl:value-of select=".//AllocLoc/@Label" />
						          	</th>
												<th colspan="1" width="33%">
						        	  	<xsl:value-of select=".//AllocFund/@Label" />
												</th>
												<th colspan="1" width="33%">						
							            <xsl:value-of select=".//AllocTrkFund/@Label" />
						    	  		</th>
       	</tr> 
       	<tr>
    	     		<th width="10%">
			          <xsl:value-of select=".//AllocLoc/AllocLabel1" />
			        </th>
			      	<th width="10%">
	  	       	 <xsl:value-of select=".//AllocLoc/AllocLabel2" />
	  	 		    </th>
	  	 		    <th width="10%">
				       <xsl:value-of select=".//AllocLoc/AllocLabel3" />
	  	 		    </th>          	
			        <th width="20%">
			           <xsl:value-of select=".//AllocFund/AllocLabel4" />
			        </th>
    	        <th width="20%">
						   <xsl:value-of select=".//AllocTrkFund/AllocLabel6" />
	  		      </th>
	  		       </tr>  
	  	   		</xsl:otherwise>
	  	   		</xsl:choose>
	      

   	  	</thead>
        <xsl:apply-templates select="./PartSix/AllocByPerc" />
        <xsl:apply-templates select="./PartSix/AllocByCopy" />
    </table>
</xsl:template>
<xsl:template match="PartSix/AllocByPerc">
	<xsl:for-each select="LocationDetail">
    <tr>
	    <td align="left" valign="top">
        <xsl:value-of select= "Location" />
        <br />
	    </td>
	    <td align="right" valign="top">
	    	<xsl:value-of select="OrderedCpy" />	
        <br />	    	
	    </td>
	    <td align="left" valign="top">
				<xsl:value-of select="Shipto" />
        <br />				
	    </td>
	    <td align="left" valign="top">
        <xsl:value-of select= "FundNumber" />
        <br />
	    </td>	    
	    <td align="right" valign="top">
        <xsl:value-of select= "FundPercent" />
        <br />
	    </td>	    
	    <td align="left" valign="top">
        <xsl:value-of select= "FundTrackNumber" />
        <br />
	    </td>	    
	    <td align="right" valign="top">
        <xsl:value-of select= "FundTrackPercent" />
        <br />
	    </td>	    
		</tr>
	</xsl:for-each>
</xsl:template>
<xsl:template match="PartSix/AllocByCopy">
    <xsl:for-each select="LocationDetail">
	    <tr>
		    <td align="left" valign="top">
	        <xsl:value-of select= "Location" />
        	<br />
		    </td>
		    <td align="right" valign="top">
					<xsl:value-of select="OrderedCpy" />	
        	<br />
		    </td>
		    <td align="left" valign="top">
					<xsl:value-of select="Shipto" />
        	<br />		    
		    </td>
		    <td align="left" valign="top">
	        <xsl:value-of select= "FundNumber" />
        	<br />		    
		    </td>	    
		    <td align="left" valign="top">
	        <xsl:value-of select= "FundTrackNumber" />
        	<br />		    
		    </td>	    
			</tr>
		</xsl:for-each>
</xsl:template>
</xsl:stylesheet>