<?xml version="1.0" ?> 
<!-- Copyright 2002 Geac Canada Limited                           -->
<!-- created for Geac Geos2 product on January 15, 2002.          -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0" />

<xsl:template match="/CitationList">
    <html>
        <head></head>
        <body>
            <xsl:apply-templates select="MoreList" mode="FirstSet"/>
            <div align="left" style="font-family:Arial Unicode MS; font-size:12pt; background=lightyellow">
                <xsl:apply-templates select="Total" />
                <p style="border-style:solid; border-width: 5px; border-color:#0000ff">
                    <table>
                        <xsl:apply-templates select="List" />
                    </table>
                </p>
                <xsl:apply-templates select="Total" />
            </div>
            <xsl:apply-templates select="MoreList" mode="SecondSet" />
        </body>
    </html>
</xsl:template>

<xsl:template match="Total">
    <p>
        <b>
        <xsl:text>Displayed:&#160;</xsl:text><xsl:value-of select="@From" />
        <xsl:text>&#160;-&#160;</xsl:text><xsl:value-of select="@To" />
        <xsl:text>&#160;of&#160;</xsl:text><xsl:value-of select="." />
        </b>
    </p>
</xsl:template>

<xsl:template match="List">
    <xsl:apply-templates select=".//CourseID">
        <xsl:with-param name="objectnum" select="@ObjNum" />
        <xsl:with-param name="sequence" select="@SeqNum" />
    </xsl:apply-templates>
    <xsl:apply-templates select=".//InstructorName">
        <xsl:with-param name="objectnum" select="@ObjNum" />
        <xsl:with-param name="sequence" select="@SeqNum" />
    </xsl:apply-templates>
    <xsl:apply-templates select=".//Meets">
        <xsl:with-param name="objectnum" select="@ObjNum" />
        <xsl:with-param name="sequence" select="@SeqNum" />
    </xsl:apply-templates>
    <tr><td>&#160;</td><td>&#160;</td><td>&#160;</td></tr>
</xsl:template>

<xsl:template match="CourseID">
    <xsl:param name="objectnum" />
    <xsl:param name="sequence" />
    <tr>
        <td align="left" valign="top">
            <span style="color:black">
                <b><xsl:value-of select="$sequence" /></b>
            </span>
        </td>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Course :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <xsl:element name="a">
            <xsl:attribute name="href">#<xsl:value-of select="$objectnum" /></xsl:attribute>
            <xsl:attribute name="title">Click to select</xsl:attribute>
            <span style="color:blue">
                <b><xsl:value-of select="." /></b>
            </span>
            </xsl:element>
        </td>
        <xsl:if test=".//InstructorName">
            <xsl:apply-templates select=".//InstructorName" />
        </xsl:if>        
        <xsl:if test=".//Meets">
            <xsl:apply-templates select=".//Meets" />
        </xsl:if>        
    </tr>
</xsl:template>


<xsl:template match="InstructorName">
    <tr>
        <td>&#160;</td>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Instructor :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>
        </td>
    </tr>
</xsl:template>
<xsl:template match="Meets">
    <tr>
        <td>&#160;</td>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Meets :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>
        </td>
    </tr>
</xsl:template>
<xsl:template match="MoreList" mode="FirstSet">
    <xsl:if test="@Previous">
        <input type="button" name="previous_top" value="Previous " />
        <xsl:text>&#160;</xsl:text>
    </xsl:if>
    <input type="text" name="jumpnum_top" size="4" />
    <input type="button" name="jumpto_top" value="Jump to #" />
    <xsl:text>&#160;</xsl:text>
    <xsl:if test="@Next">
        <input type="button" name="next_top" value="  Next   " />
    </xsl:if>
</xsl:template>

<xsl:template match="MoreList" mode="SecondSet">
    <xsl:if test="@Previous">
        <input type="button" name="previous_bottom" value="Previous " />
        <xsl:text>&#160;</xsl:text>
    </xsl:if>
    <input type="text" name="jumpnum_bottom" size="4" />
    <input type="button" name="jumpto_bottom" value="Jump to #" />
    <xsl:text>&#160;</xsl:text>
    <xsl:if test="@Next">
        <input type="button" name="next_bottom" value="  Next   " />
    </xsl:if>
</xsl:template>

</xsl:stylesheet>