<?xml version="1.0" ?>
<!-- Copyright 2002 Geac Canada Limited                           -->
<!-- created for Geac Geos2 product on March 26, 2002.            -->
<!--                  last modified on May 2, 2002.               -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0" />

<xsl:template match="SearchResults">
    <html>
        <head>
            <title>RBR Detail Display</title>
            <style>
                .disp {color:black; font-family:"Arial Unicode MS"; font-size:12pt; font-weight:bold}
                .tabledisp {color:black; font-family:"Arial Unicode MS"; font-size:10pt; font-weight:bold}
                .buttondisp {font-size:8pt; font-weight:bold}
                .noshow {visibility:hidden}
            </style>
            <script language="JavaScript">
                function HoldRequest(request_value)
                {
                    document.RBRDetail.DummyPlaceHold.value=request_value;
                    document.RBRDetail.DummyPlaceHold.click();
                }
            </script>
        </head>
        <body style="background=lightyellow">
            <form name="RBRDetail">
            <div>
                <table class="disp" width="100%" cols="2">
                    <tr>
                        <th width="20%"></th>
                        <th width="80%"></th>
                    </tr>
                    <xsl:apply-templates select="Resource" />              
		</table>
                <input class="noshow" type="button" name="DummyPlaceHold" value="dummy" />
            </div> 
            <hr />
            <div>
		<table id="Courses" class="tabledisp" width="100%" border="2" cols="5">
                    <thead style="height:20; align:left; background-color:silver">
                        <tr>
		            <th width="20%">Location</th>
			    <th width="40%">Title/Author/Call Number</th>
			    <th width="10%">Volume</th>
			    <th width="20%">Status</th>
			    <th width="10%">&#160;</th>
		        </tr> 
 		    </thead>
 		    <xsl:apply-templates select="Resource/RBRTitles" />
		</table> 
            </div>
            </form>
        </body>
    </html>
</xsl:template>

<xsl:template match="Resource">
    <xsl:apply-templates select=".//CourseID" />
    <xsl:apply-templates select=".//CourseName" />
    <xsl:apply-templates select=".//Instructor" />
    <xsl:apply-templates select=".//Department" />
    <xsl:apply-templates select=".//Meets" />
    <xsl:apply-templates select=".//Term" />
    <xsl:apply-templates select=".//Year" />
</xsl:template>


<xsl:template match="CourseID">
    <tr>
        <td align="left" valign="top" style="color:magenta">
            <xsl:text>Course Code</xsl:text>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="CourseName">
    <tr> 
        <td align="left" valign="top" style="color:magenta">
            <xsl:text>Course Name</xsl:text>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Instructor">
    <tr>
        <td align="left" valign="top" style="color:magenta">
            <xsl:text>Instructor</xsl:text>
        </td>
        <td align="left">
            <xsl:value-of select="./InstructorName" /><br />
            <xsl:value-of select="./InstructorPhone" />
            <xsl:if test="normalize-space(./InstructorPhnExt)">
                <xsl:text>&#160;&#160;&#160;Ext. </xsl:text>
                <xsl:value-of select="./InstructorPhnExt" />
            </xsl:if>
            <br />
            <xsl:value-of select="./InstructorEmail" />
            <xsl:if test="./InstrURI">
                <br />
                <xsl:element name="a">
                    <xsl:attribute name="class">instr</xsl:attribute>
                    <xsl:attribute name="href">#URL|<xsl:value-of select="normalize-space(./InstrURI)" /></xsl:attribute>
		    <xsl:choose>
		        <xsl:when test="./InstrURI/@Linktext">
                            <span style="color:blue"><xsl:value-of select="./InstrURI/@Linktext"/></span>
	                </xsl:when>
		        <xsl:otherwise>
			    <span style="color:blue"><xsl:value-of select="normalize-space(./InstrURI)"/></span>
		        </xsl:otherwise>
		    </xsl:choose>
                </xsl:element>
            </xsl:if>
        </td>
    </tr>
</xsl:template>

<xsl:template match="Department">
    <tr>
        <td align="left" valign="top" style="color:magenta">
            <xsl:text>Department</xsl:text>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Meets">
    <tr>
        <td align="left" valign="top" style="color:magenta">
            <xsl:text>Meets</xsl:text>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Term">
    <tr>
        <td align="left" valign="top" style="color:magenta">
            <xsl:text>Term</xsl:text>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Year">
    <tr>
        <td align="left" valign="top" style="color:magenta">
            <xsl:text>Year</xsl:text>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="RBRTitles">
    <xsl:for-each select=".//RBRTitleDetail">
        <tr>
            <td align="left" valign="top">
                <xsl:value-of select="normalize-space(concat(./Location/@Institution, ' ', ./Location/@Sublocation,' ', ./Location/@Collection))" />
	        <br />
            </td>
	    <td id="TitleCol" align="left" valign="top">
	        <xsl:value-of select="./Title" /><br />
	        <xsl:value-of select="./Author" /><br />
	        <xsl:value-of select="normalize-space(concat(./Location/@CallNumberPrefix, ' ', ./Location/@CallNumber,' ', ./Location/@CallNumberSuffix))" />
                <br />
	    </td>
            <td align="left" valign="top">
                <xsl:value-of select="./VolumeNumber" />
                <br />
            </td>   
	    <td align="left" valign="top">
	        <xsl:value-of select="./Status" />
                <br />
	    </td>
            <td id="PlaceHoldCol" align="center">
                <xsl:choose>
                    <xsl:when test="./TitleLCN">
                        <xsl:variable name="titleLCN" select="normalize-space(./TitleLCN)" />
                        <xsl:variable name="volbarcode">
                            <xsl:choose>
                                <xsl:when test="normalize-space(./VolBarcode)">
                                    <xsl:value-of select="normalize-space(./VolBarcode)" />
                                </xsl:when>
                            </xsl:choose>
                        </xsl:variable>
                        <xsl:choose>                   
                            <xsl:when test="starts-with($titleLCN, 'R')">
                                <xsl:text>&#160;</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <input class="buttondisp" type="button">
                                    <xsl:attribute name="name">PlaceHold</xsl:attribute>
                                    <xsl:attribute name="value"><xsl:text>Place Hold</xsl:text></xsl:attribute>
                                    <xsl:attribute name="id">
                                        <xsl:choose>
                                            <xsl:when test="normalize-space($volbarcode)">
                                                <xsl:value-of select="concat($titleLCN, ':', $volbarcode)" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of select="$titleLCN" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:attribute>
                                    <xsl:attribute name="onclick">HoldRequest(id)</xsl:attribute>
                                </input>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>&#160;</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </td>    
        </tr>
    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>