<?xml version="1.0" ?> 
<!-- Copyright 2002 Geac Canada Limited                           -->
<!-- created for Geac Geos2 product on January 15, 2002.          -->
<!--                  last modified on March 13, 2002.            -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0" />

<xsl:template match="/CitationList">
    <html>
        <head>
            <title>Citation List for Community Information</title>
            <style>
                .disp {color:black; font-family:"Arial Unicode MS"; font-size:12pt; font-weight:bold}
                .tabledisp {color:black; font-family:"Arial Unicode MS"; font-size:12pt; font-weight:bold}
                .inputdisp {color:black; font-family:"Arial Unicode MS"; font-size:10pt; font-weight:bold}
            </style>
        </head>
        <body>
            <xsl:apply-templates select="MoreList" mode="FirstSet"/>
            <div class="disp" align="left" style="background=lightyellow">
                <xsl:apply-templates select="Total" />
                <p style="border-style:solid; border-width: 5px; border-color:#0000ff">
                    <table class="tabledisp">
                        <xsl:apply-templates select="List" />
                    </table>
                </p>
                <xsl:apply-templates select="Total" />
            </div>
            <xsl:apply-templates select="MoreList" mode="SecondSet" />
        </body>
    </html>
</xsl:template>

<xsl:template match="Total">
    <p>
        <xsl:text>Displayed:&#160;</xsl:text><xsl:value-of select="@From" />
        <xsl:text>&#160;-&#160;</xsl:text><xsl:value-of select="@To" />
        <xsl:text>&#160;of&#160;</xsl:text><xsl:value-of select="." />
    </p>
</xsl:template>

<xsl:template match="List">
    <xsl:apply-templates select=".//Name">
        <xsl:with-param name="objectnum" select="@ObjNum" />
        <xsl:with-param name="sequence" select="@SeqNum" />
    </xsl:apply-templates>
    <xsl:apply-templates select=".//OrganizationAgency">
        <xsl:with-param name="objectnum" select="@ObjNum" />
        <xsl:with-param name="sequence" select="@SeqNum" />
    </xsl:apply-templates>
    <xsl:apply-templates select=".//ProgramService">
        <xsl:with-param name="objectnum" select="@ObjNum" />
        <xsl:with-param name="sequence" select="@SeqNum" />
    </xsl:apply-templates>
    <xsl:apply-templates select=".//EventName">
        <xsl:with-param name="objectnum" select="@ObjNum" />
        <xsl:with-param name="sequence" select="@SeqNum" />
    </xsl:apply-templates>
    <xsl:apply-templates select=".//Address" />     
    <xsl:apply-templates select=".//URI" />
    <tr><td>&#160;</td><td>&#160;</td><td>&#160;</td></tr>
</xsl:template>

<xsl:template match="Name">
    <xsl:param name="objectnum" />
    <xsl:param name="sequence" />
    <tr>
        <td align="left" valign="top">
            <xsl:value-of select="$sequence" />
        </td>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Name :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:element name="a">
                <xsl:attribute name="href">#<xsl:value-of select="$objectnum" /></xsl:attribute>
                <xsl:attribute name="title">Click to select</xsl:attribute>
                <span style="color:blue"><xsl:value-of select="." /></span>
            </xsl:element>
        </td>
        <xsl:if test=".//Address">
            <xsl:apply-templates select=".//Address" />
        </xsl:if>
    </tr>
</xsl:template>

<xsl:template match="OrganizationAgency">
    <xsl:param name="objectnum" />
    <xsl:param name="sequence" />
    <tr>
        <td align="left" valign="top">
            <xsl:value-of select="$sequence" />
        </td>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Name :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:element name="a">
                <xsl:attribute name="href">#<xsl:value-of select="$objectnum" /></xsl:attribute>
                <xsl:attribute name="title">Click to select</xsl:attribute>
                <span style="color:blue"><xsl:value-of select="." /></span>
            </xsl:element>
        </td>
        <xsl:if test=".//Address">
            <xsl:apply-templates select=".//Address" />
        </xsl:if>
    </tr>
</xsl:template>

<xsl:template match="ProgramService">
    <xsl:param name="objectnum" />
    <xsl:param name="sequence" />
    <tr>
        <td align="left" valign="top">
            <xsl:value-of select="$sequence" />
        </td>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Name :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:element name="a">
                <xsl:attribute name="href">#<xsl:value-of select="$objectnum" /></xsl:attribute>
                <xsl:attribute name="title">Click to select</xsl:attribute>
                <span style="color:blue"><xsl:value-of select="." /></span>
            </xsl:element>
        </td>
        <xsl:if test=".//Address">
            <xsl:apply-templates select=".//Address" />
        </xsl:if>
    </tr>
</xsl:template>

<xsl:template match="EventName">
    <xsl:param name="objectnum" />
    <xsl:param name="sequence" />
    <tr>
        <td align="left" valign="top">
            <xsl:value-of select="$sequence" />
        </td>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Name :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:element name="a">
                <xsl:attribute name="href">#<xsl:value-of select="$objectnum" /></xsl:attribute>
                <xsl:attribute name="title">Click to select</xsl:attribute>
                <span style="color:blue"><xsl:value-of select="." /></span>
            </xsl:element>
        </td>
    </tr>
</xsl:template>

<xsl:template match="Address">
    <tr>
        <td>&#160;</td>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Address :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="URI">
    <tr>
        <td>&#160;</td>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>URL :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:element name="a">
                <xsl:attribute name="href">#URL|<xsl:value-of select="." /></xsl:attribute>
	        <xsl:attribute name="title">Click to select</xsl:attribute>
	        <xsl:choose>
	            <xsl:when test="@Linktext">
                        <span style="color:blue"><xsl:value-of select="@Linktext"/></span>
	            </xsl:when>
	            <xsl:otherwise>
	                <span style="color:blue"><xsl:value-of select="."/></span>
	            </xsl:otherwise>
	        </xsl:choose>
            </xsl:element>
        </td>
    </tr>
</xsl:template>

<xsl:template match="MoreList" mode="FirstSet">
    <xsl:if test="@Previous">
        <input class="inputdisp" type="button" name="previous_top" value="Previous " />
        <xsl:text>&#160;</xsl:text>
    </xsl:if>
    <input class="inputdisp" type="text" name="jumpnum_top" size="4" />
    <input class="inputdisp" type="button" name="jumpto_top" value="Jump to #" />
    <xsl:text>&#160;</xsl:text>
    <xsl:if test="@Next">
        <input class="inputdisp" type="button" name="next_top" value="  Next   " />
    </xsl:if>
</xsl:template>

<xsl:template match="MoreList" mode="SecondSet">
    <xsl:if test="@Previous">
        <input class="inputdisp" type="button" name="previous_bottom" value="Previous " />
        <xsl:text>&#160;</xsl:text>
    </xsl:if>
    <input class="inputdisp" type="text" name="jumpnum_bottom" size="4" />
    <input class="inputdisp" type="button" name="jumpto_bottom" value="Jump to #" />
    <xsl:text>&#160;</xsl:text>
    <xsl:if test="@Next">
        <input class="inputdisp" type="button" name="next_bottom" value="  Next   " />
    </xsl:if>
</xsl:template>

</xsl:stylesheet>