<?xml version="1.0" ?>
<!-- Copyright 2002 Geac Canada Limited                           -->
<!-- created for Geac Geos2 product on January 15, 2002.          -->
<!--                  last modified on March 13, 2002.            -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0" />

<xsl:template match="SearchResults">
    <html>
        <head>
            <title>Community Information Detail Display</title>
            <style>
                .disp {color:black; font-family:"Arial Unicode MS"; font-size:12pt; font-weight:bold}
                .credit {color:green; font-family:"Arial Unicode MS"; font-size:8pt; font-weight:bold}
            </style>
        </head>
        <body>
            <xsl:variable name="ancillary" select="document('GeacAncillary.xml')"/>
            <div style="position:absolute; font-family:Times New Roman; font-size:96; color:#F0F0F0; z-index:-1">
	        <xsl:value-of select="$ancillary//watermark"/>
                <img src="BooksOutline.gif"/>
            </div>

            <div>
                <table class="disp">
                    <xsl:apply-templates select="Resource"  />
                </table>
            </div>
        </body>
    </html>
</xsl:template>

<xsl:template match="Resource">
    <xsl:apply-templates select=".//Name" />
    <xsl:apply-templates select=".//OrganizationAgency" />
    <xsl:apply-templates select=".//ProgramService" />
    <xsl:apply-templates select=".//EventName" />
    <xsl:apply-templates select=".//Address" />
    <xsl:apply-templates select=".//Activities" />
    <xsl:apply-templates select=".//Credentials" />
    <xsl:apply-templates select=".//Notes" />
    <xsl:apply-templates select=".//OtherNotes" />
    <xsl:apply-templates select=".//Affiliation" />
    <xsl:apply-templates select=".//SponsoredBy" />
    <xsl:apply-templates select=".//Contact" />
    <xsl:apply-templates select=".//Official" />
    <xsl:apply-templates select=".//Hours" />
    <xsl:apply-templates select=".//Eligibility" />
    <xsl:apply-templates select=".//Fees" />
    <xsl:apply-templates select=".//Languages" />
    <xsl:apply-templates select=".//Directions" />
    <xsl:apply-templates select=".//ProgramSeries" />
    <xsl:apply-templates select=".//Subjects" />
    <xsl:apply-templates select=".//BroadTerm" />
    <xsl:apply-templates select=".//Audience" />
    <xsl:apply-templates select=".//OperatedBy" />
    <xsl:apply-templates select=".//URI" />
    <xsl:apply-templates select=".//URIPicture" />
</xsl:template>

<xsl:template match="Name">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Name :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="OrganizationAgency">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Name :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="ProgramService">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Name :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="EventName">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Name :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Address">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Address :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Activities">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Activities :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Credentials">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Credentials :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Notes">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Notes :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="OtherNotes">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Other&#160;Notes :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Affiliation">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Affiliation :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="SponsoredBy">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Sponsored&#160;By :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Contact">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Contact :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Official">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Official :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Hours">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Hours :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Eligibility">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Eligibility :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Fees">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Fees :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Languages">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Languages :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Directions">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Directions :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="ProgramSeries">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Program&#160;Series :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Subjects">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Subjects :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="BroadTerm">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Broad&#160;Term :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Audience">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Audience :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="OperatedBy">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Operated&#160;By :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="URI">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>URI :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <xsl:element name="a">
	        <xsl:attribute name="href">#URL|<xsl:value-of select="." /></xsl:attribute>
		<xsl:attribute name="title">Click to select</xsl:attribute>
		<xsl:choose>
		    <xsl:when test="@Linktext">
	                <span style="color:blue"><xsl:value-of select="@Linktext"/></span>
	            </xsl:when>
		    <xsl:otherwise>
		        <span style="color:blue"><xsl:value-of select="."/></span>
		    </xsl:otherwise>
		</xsl:choose>
            </xsl:element>
        </td>
    </tr>
</xsl:template>

<xsl:template match="URIPicture">
    <tr>
        <td>&#160;</td>
        <td>
            <br/>
            <xsl:element name="a">
                <xsl:attribute name="href">#URL|<xsl:value-of select="." /></xsl:attribute>
                <xsl:element name="img">
                    <xsl:attribute name="src"><xsl:value-of select="." /></xsl:attribute> 
                    <xsl:attribute name="width">20%</xsl:attribute>
                    <!-- <xsl:attribute name="height">200</xsl:attribute> -->
                    <xsl:if test="@alt">
                        <xsl:attribute name="alt"><xsl:value-of select="@alt" /></xsl:attribute>
                        <span class="credit">
                            <br/><xsl:value-of select="@alt" />
                        </span>
                    </xsl:if>
                    <xsl:if test="@Credit">
                        <span class="credit">
                            <br/><xsl:value-of select="@Credit" />
                        </span>
                    </xsl:if>
                </xsl:element>
            </xsl:element>
        </td>
    </tr>
</xsl:template>

</xsl:stylesheet>