<?xml version="1.0" ?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<!-- Copyright 2001 Geac Canada Limited                                     -->
<!-- created for Geac Geos2 product on March 12, 2001.                      -->
<!--                  last modified on March 13, 2002.                      -->
<xsl:output method="html" version="4.0" />

<xsl:template match="SearchResults">
    <html>
        <head>
            <title>Single-part Item Display</title>
            <style>
                .disp {color:black; font-family:"Arial Unicode MS"; font-size:12pt; font-weight:bold}
                .tabledisp {color:black; font-family:"Arial Unicode MS"; font-size:9pt; font-weight:bold}
            </style>
        </head>
        <body>
            <xsl:variable name="ancillary" select="document('GeacAncillary.xml')"/>
            <div style="position:absolute; font-family:Times New Roman; font-size:96; color:#F0F0F0; z-index:-1">
	        <xsl:value-of select="$ancillary//watermark"/>
                <img src="BooksOutline.gif"/>
            </div>

            <div>
                <table class="disp">
                    <xsl:apply-templates select="Resource"  />
                </table>
            </div>
            
            <div>
            	<xsl:apply-templates select=".//HeldDetails" />
            </div>
        </body>
    </html>
</xsl:template>

<xsl:template match="Resource">
    <xsl:apply-templates select=".//LCN" />
    <xsl:apply-templates select=".//Creator" />
    <xsl:apply-templates select=".//Title" />
<!--    <xsl:apply-templates select=".//Subject" /> -->
    <xsl:apply-templates select=".//Edition" />
    <xsl:apply-templates select=".//Year" />
    <xsl:apply-templates select=".//Publisher" />
    <xsl:apply-templates select=".//ISBN" />
<!--    <xsl:apply-templates select=".//Contributor" /> -->
    <xsl:apply-templates select=".//NoOfTitleHolds" />
    <xsl:apply-templates select=".//URI" />
<!--
    <xsl:apply-templates select=".//URIPicture" />
    <xsl:apply-templates select=".//URIImage" />
-->
</xsl:template>

<!-- wzr bibsection templates  -->

<xsl:template match="LCN">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>LCN :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Creator">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Creator :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Title">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Title :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Edition">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Edition :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Year">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Date :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Publisher">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Publisher :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="ISBN">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>ISBN :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Subject">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Subject :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Contributor">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Contributor :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="NoOfTitleHolds">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Holds :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="URI">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>URI :</xsl:text>
            </span>
        </td>
        <td align="left">
	    <xsl:element name="a">
                <xsl:attribute name="href">#URL|<xsl:value-of select="." /></xsl:attribute>
		<xsl:attribute name="title">Click to select</xsl:attribute>
		<xsl:choose>
		    <xsl:when test="@Linktext">
	                <span style="color:blue"><xsl:value-of select="@Linktext"/></span>
	            </xsl:when>
		    <xsl:otherwise>
			<span style="color:blue"><xsl:value-of select="."/></span>
		    </xsl:otherwise>
		</xsl:choose>
            </xsl:element>
        </td>
    </tr>
</xsl:template>

<xsl:template match="URIPicture">
    <tr>
        <td>&#160;</td>
        <td>
            <br/>
            <xsl:element name="a">
                <xsl:attribute name="href">#URL|<xsl:value-of select="normalize-space(.)" /></xsl:attribute>
                <xsl:element name="img">
                    <xsl:attribute name="src"><xsl:value-of select="." /></xsl:attribute> 
                    <xsl:attribute name="width">20%</xsl:attribute>
                    <xsl:if test="@alt">
                        <xsl:attribute name="alt"><xsl:value-of select="@alt" /></xsl:attribute>
                        <span style="font-family:Arial Unicode MS; font-size:8pt">
                            <br/><xsl:value-of select="@alt" />
                        </span>
                    </xsl:if>
                    <xsl:if test="@Credit">
                        <span style="font-family:Arial Unicode MS; font-size:8pt">
                            <br/><xsl:value-of select="@Credit" />
                        </span>
                    </xsl:if>
                </xsl:element>
            </xsl:element>
        </td>
    </tr>
</xsl:template>

<xsl:template match="URIImage">
    <tr>
        <td>&#160;</td>
        <td>
            <br/>
            <xsl:variable name="linkpath">
                <xsl:choose>
                    <xsl:when test="@LinkPath">
                        <xsl:value-of select="normalize-space(@LinkPath)" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="normalize-space(.)" />
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:element name="a">
                <xsl:attribute name="href">#URL|<xsl:value-of select="$linkpath" /></xsl:attribute>
                <xsl:element name="img">
                    <xsl:attribute name="src"><xsl:value-of select="normalize-space(.)" /></xsl:attribute> 
                    <xsl:attribute name="width">20%</xsl:attribute>
                    <xsl:if test="@ImageDesc">
                        <xsl:attribute name="alt"><xsl:value-of select="@ImageDesc" /></xsl:attribute>
                    </xsl:if>
                </xsl:element>
            </xsl:element>
        </td>
    </tr>
</xsl:template>

<xsl:template match="HeldDetails">
    <br /><hr />
        <table class="tabledisp" width="100%" border="1">
	    <thead style="height:20; align:left; background-color:silver">
		<tr>
		    <th width="20%">Call Number</th>
		    <th width="20%">Status</th>
		</tr>
	    </thead>
	    <xsl:call-template name="createCaption" />
	    <xsl:apply-templates select="./HeldDetailBlock" />
	</table>
</xsl:template>

<xsl:template match="HeldDetailBlock">
    <xsl:for-each select="HeldItem">
	<tr>
	    <td align="left" valign="top">
                <xsl:variable name="callnum" select="normalize-space(concat(./HeldLocation/@DtlCallNumberPrefix, ' ',./HeldLocation/@DtlCallNumber,' ',./HeldLocation/@DtlCallNumberSuffix,' ',./HeldLocation/@DtlCopyNumber))"></xsl:variable>
                <xsl:choose>
                    <xsl:when test="string-length($callnum)>0">
	                <xsl:value-of select="$callnum" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>&#160;</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
	    </td>
	    <td align="left" valign="top">
		<xsl:value-of select="HeldCircStatus" />
	    </td>
	</tr>
    </xsl:for-each>
</xsl:template>

<xsl:template name="createCaption">
    <caption>
	<Table class="disp" width="100%" >
	    <tr>
	        <th width="100%">
		    <xsl:value-of select="normalize-space(concat(./HeldDetailBlock/HeldItem/HeldLocation/@DtlInstitution, ' './HeldDetailBlock/HeldItem/HeldLocation/@DtlSublocation,' './HeldDetailBlock/HeldItem/HeldLocation/@DtlCollection))" />
		</th>
	    </tr>
	</Table>
    </caption>
</xsl:template>

</xsl:stylesheet>