<?xml version="1.0" ?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<!-- Copyright 2001 Geac Canada Limited                   -->
<!-- created for Geac Geos2 product on March 12, 2001.    -->
<!--                  last modified on May 16, 2001.      -->
<xsl:output method="html" version="4.0" />

<xsl:template match="SearchResults">
    <html>
        <head></head>
        <body>
            <xsl:variable name="ancillary" select="document('GeacAncillary.xml')"/>
            <div style="position:absolute; font-family:Times New Roman; font-size:96; color:#F0F0F0; z-index:-1">
	        <xsl:value-of select="$ancillary//watermark"/>
                <img src="BooksOutline.gif"/>
            </div>

            <div style="font-family:Arial Unicode MS; font-size:12">
                <table>
                    <xsl:apply-templates select="Resource"  />
                </table>
            </div>
            
            <div>
            	<xsl:apply-templates select=".//HeldDetails" />
            </div>
        </body>
    </html>
</xsl:template>

<xsl:template match="Resource">
    <xsl:apply-templates select=".//LCN" />
    <xsl:apply-templates select=".//Creator" />
    <xsl:apply-templates select=".//Title" />
<!--    <xsl:apply-templates select=".//Subject" /> -->
    <xsl:apply-templates select=".//Edition" />
    <xsl:apply-templates select=".//Year" />
    <xsl:apply-templates select=".//Publisher" />
    <xsl:apply-templates select=".//ISBN" />
<!--    <xsl:apply-templates select=".//Contributor" /> -->
    <xsl:apply-templates select=".//NoOfTitleHolds" />
</xsl:template>

<!-- wzr bibsection templates  -->

<xsl:template match="LCN">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>LCN :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>
        </td>
    </tr>
</xsl:template>

<xsl:template match="Creator">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Creator :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>
        </td>
    </tr>
</xsl:template>

<xsl:template match="Title">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Title :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>
        </td>
    </tr>
</xsl:template>

<xsl:template match="Edition">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Edition :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>
        </td>
    </tr>
</xsl:template>

<xsl:template match="Year">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Date :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>
        </td>
    </tr>
</xsl:template>

<xsl:template match="Publisher">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Publisher :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>
        </td>
    </tr>
</xsl:template>

<xsl:template match="ISBN">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>ISBN :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>
        </td>
    </tr>
</xsl:template>

<xsl:template match="Subject">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Subject :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>
        </td>
    </tr>
</xsl:template>

<xsl:template match="Contributor">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Contributor :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>
        </td>
    </tr>
</xsl:template>

<xsl:template match="NoOfTitleHolds">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <b><xsl:text>Holds :</xsl:text></b>
            </span>
        </td>
        <td align="left">
            <span style="color:black">
                <b><xsl:value-of select="." /></b>
            </span>
        </td>
    </tr>
</xsl:template>

<xsl:template match="HeldDetails">
	<table width="100%" border="1" fontsize="9">
			<thead style="height:20; align:left; background-color:silver">
				<tr>
					<th width="35%">&#160;</th>
					<th width="35%">Status</th>
				</tr>
			</thead>
			<xsl:call-template name="createCaption" />
			<xsl:apply-templates select="./HeldDetailBlock" />
	</table>
</xsl:template>

<xsl:template match="HeldDetailBlock">
	<xsl:for-each select="HeldItem">
		<tr>
			<td align="left" valign="top">
				<span style="color:black">
					<b>
						<xsl:choose>
						<xsl:when test="HeldItemLabel">
							<xsl:value-of select="HeldItemLabel" />	
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>&#160;</xsl:text>
						</xsl:otherwise>
						</xsl:choose>
					</b>
				</span>
			</td>
			<td align="left" valign="top">
				<span style="color:black">
					<b>
						<xsl:value-of select="HeldCircStatus" />
					</b>
				</span>
			</td>
		</tr>
	</xsl:for-each>
</xsl:template>

<xsl:template name="createCaption">
	
	<caption> 
<!-- 	<xsl:value-of select="./HeldDetailBlock/HeldItem/HeldLocation/@DtlInstitution" /> -->

		<span style="color:black">
			<b>
			<xsl:value-of select="normalize-space(concat(./HeldDetailBlock/HeldItem/HeldLocation/@DtlInstitution, ' ',./HeldDetailBlock/HeldItem/HeldLocation/@DtlSublocation,' ',./HeldDetailBlock/HeldItem/HeldLocation/@DtlCollection))" />
			</b><br/>
		</span>
	</caption>
</xsl:template>

</xsl:stylesheet>