<?xml version="1.0" ?> 
<!-- Copyright 2002 Geac Canada Limited                           -->
<!-- created for Geac Geos2 product on July 3, 2002.              -->
<!--                  last modified on                            -->

<xsl:stylesheet xmlns:marc="http://www.loc.gov/MARC21/slim" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0" />

<xsl:template match="/CitationList">
    <html>
        <head>
            <title>Bibilographic MARC Citation List</title>
            <style>
                .disp {color:black; font-family:"Arial Unicode MS"; font-size:12pt; font-weight:bold}
                .tabledisp {color:black; font-family:"Arial Unicode MS"; font-size:12pt; font-weight:bold}
                .inputdisp {color:black; font-family:"Arial Unicode MS"; font-size:10pt; font-weight:bold}
            </style>
        </head>
        <body>
            <xsl:apply-templates select="MoreList" mode="FirstSet"/>
            <div class="disp" align="left" style="background=lightyellow">
                <xsl:apply-templates select="Total" />
                <p style="border-style:solid; border-width: 5px; border-color:#0000ff">
                    <table class="tabledisp" width="100%" cols="3">
                        <tr>
                            <th width="3%"></th>
                            <th width="10%"></th>
                            <th width="87%"></th>
                        </tr>
                        <xsl:apply-templates select="List" />
                    </table>
                </p>
                <xsl:apply-templates select="Total" />
            </div>
            <xsl:apply-templates select="MoreList" mode="SecondSet" />
        </body>
    </html>
</xsl:template>

<xsl:template match="Total">
    <p>
        <xsl:text disable-output-escaping='yes'>Displayed:&#160;</xsl:text><xsl:value-of select="@From" />
        <xsl:text disable-output-escaping='yes'>&#160;-&#160;</xsl:text><xsl:value-of select="@To" />
        <xsl:text disable-output-escaping='yes'>&#160;of&#160;</xsl:text><xsl:value-of select="." />
    </p>
</xsl:template>

<xsl:template match="List">
    <xsl:choose>
        <xsl:when test="@ErrMsg">
            <tr>
                <td align="left" valign="top">
                    <xsl:value-of select="@SeqNum" />
                </td>
                <td align="left" colspan="2">
                    <span style="color:red"><xsl:value-of select="@ErrMsg" /></span>
                </td>
            </tr>
        </xsl:when>
        <xsl:otherwise>
            <xsl:apply-templates select=".//marc:datafield[@tag='100']" mode="author">
                <xsl:with-param name="sequence" select="@SeqNum" />
            </xsl:apply-templates>
            <xsl:choose>
                <xsl:when test=".//marc:datafield[@tag='100']">
                    <xsl:apply-templates select=".//marc:datafield[@tag='245']" mode="title">
                        <xsl:with-param name="objectnum" select="@ObjNum" />
                        <xsl:with-param name="sequence" select="0" />
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select=".//marc:datafield[@tag='245']" mode="title">
                        <xsl:with-param name="objectnum" select="@ObjNum" />
                        <xsl:with-param name="sequence" select="@SeqNum" />
                    </xsl:apply-templates>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:otherwise>
    </xsl:choose>       
    <tr><td>&#160;</td><td>&#160;</td><td>&#160;</td></tr>
</xsl:template>

<xsl:template match="marc:datafield" mode="author">
    <xsl:param name="sequence" />
    <tr>
        <td align="left" valign="top">
            <xsl:value-of select="$sequence" />
        </td>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Author :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:apply-templates />
        </td>
    </tr>
</xsl:template>

<xsl:template match="marc:datafield" mode="title">
    <xsl:param name="objectnum" />
    <xsl:param name="sequence" />
    <tr>
        <xsl:choose>
            <xsl:when test="$sequence='0'">
                <td>&#160;</td>
            </xsl:when>
            <xsl:otherwise>
                <td align="left" valign="top">
                    <xsl:value-of select="$sequence" />
                </td>
            </xsl:otherwise>
        </xsl:choose>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Title :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:element name="a">
                <xsl:attribute name="href">#<xsl:value-of select="$objectnum" /></xsl:attribute>
                <xsl:attribute name="title">Click to select</xsl:attribute>
                <span style="color:blue"><xsl:apply-templates /></span>
            </xsl:element>
        </td>
    </tr>
</xsl:template>

<xsl:template match="marc:subfield">
    <xsl:if test="@code!='6'">
        <xsl:text disable-output-escaping='yes'>&#160;</xsl:text>
        <xsl:value-of select="." />
    </xsl:if>
</xsl:template>

<xsl:template match="MoreList" mode="FirstSet">
    <xsl:if test="@Previous">
        <input class="inputdisp" type="button" name="previous_top" value="Previous " />
        <xsl:text>&#160;</xsl:text>
    </xsl:if>
    <input class="inputdisp" type="text" name="jumpnum_top" size="4" />
    <input class="inputdisp" type="button" name="jumpto_top" value="Jump to #" />
    <xsl:text>&#160;</xsl:text>
    <xsl:if test="@Next">
        <input class="inputdisp" type="button" name="next_top" value="  Next   " />
    </xsl:if>
</xsl:template>

<xsl:template match="MoreList" mode="SecondSet">
    <xsl:if test="@Previous">
        <input class="inputdisp" type="button" name="previous_bottom" value="Previous " />
        <xsl:text>&#160;</xsl:text>
    </xsl:if>
    <input class="inputdisp" type="text" name="jumpnum_bottom" size="4" />
    <input class="inputdisp" type="button" name="jumpto_bottom" value="Jump to #" />
    <xsl:text>&#160;</xsl:text>
    <xsl:if test="@Next">
        <input class="inputdisp" type="button" name="next_bottom" value="  Next   " />
    </xsl:if>
</xsl:template>

</xsl:stylesheet>