<?xml version="1.0" ?>
<!-- Copyright 2002 Geac Canada Limited                           -->
<!-- created for Geac Geos2 product on June 26, 2002.             -->
<!--                  last modified on July 15, 2002              -->

<xsl:stylesheet version="1.0" xmlns:marc="http://www.loc.gov/MARC21/slim" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.0" />

<xsl:template match="/">
    <html>
        <head>
            <title>MODS MARC Detail Display</title>
            <style>
                .disp {color:black; font-family:"Arial Unicode MS"; font-size:12pt; font-weight:bold}
            </style>
        </head>
        <body>
            <xsl:apply-templates />
        </body>
    </html>
</xsl:template>
	
<xsl:template match="marc:leader">
    <table class="disp" width="100%" cols="2">
        <tr>
            <th width="5%"></th>
            <th width="95%"></th>
        </tr>
        <tr>
            <td align="left">
	        <span style="color:blue"><xsl:text>000</xsl:text></span>
	    </td>
	    <td align="left">
	        <xsl:value-of disable-output-escaping="yes" select="translate(., ' ', '&#160;')" />
	    </td>
        </tr>
    </table>
</xsl:template>
	
<xsl:template match="marc:controlfield">
    <table class="disp" width="100%" cols="2">
        <tr>
            <th width="5%"></th>
            <th width="95%"></th>
        </tr>
        <tr>
	    <td align="left">
	        <span style="color:blue"><xsl:value-of select="format-number(@tag, '000')" /></span>
	    </td>
	    <td align="left">
	        <xsl:value-of disable-output-escaping="yes" select="translate(., ' ', '&#160;')" />
	    </td>
	</tr>
    </table>
</xsl:template>
	
<xsl:template match="marc:datafield">
    <table class="disp" width="100%" cols="3">
        <tr>
            <th width="5%"></th>
            <th width="3%"></th>
            <th width="92%"></th>
        </tr>
        <tr>
            <td align="left" valign="top">
	        <span style="color:blue"><xsl:value-of select="format-number(@tag, '000')" /></span>
	    </td>
	    <td align="left" valign="top">
                <span style="color:brown">
                    <xsl:value-of disable-output-escaping="yes" select="concat(translate(@ind1, ' ', '&#160;'),translate(@ind2, ' ', '&#160;'))" />
                </span>
	    </td>
            <td align="left">
                <xsl:apply-templates />
            </td>
        </tr>
    </table>
</xsl:template>

<xsl:template match="marc:subfield">
    <span style="color:red">
        <xsl:text>&#x2021;</xsl:text><xsl:value-of select="@code" />
    </span>
    <xsl:if test="text()">
        <xsl:value-of select="."/>
    </xsl:if>
</xsl:template>

</xsl:stylesheet>
