<?xml version="1.0" ?>
<!-- Copyright 2001 Geac Canada Limited                           -->
<!-- created for Geac Geos2 product on December 20, 2001.         -->
<!--                  last modified on April 17, 2002.            -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0" />

<xsl:template match="SearchResults">
    <html>
        <head>
            <title>Detail Display</title>
            <style>
                body {background-image:url("BooksOutline.gif"); background-position:center center; background-repeat:no-repeat; background-attachment:fixed}
                .disp {color:black; font-family:"Arial Unicode MS"; font-size:12pt; font-weight:bold}
                .tabledisp {color:black; font-family:"Arial Unicode MS"; font-size:12pt; font-weight:bold}
                .credit {color:green; font-family:"Arial Unicode MS"; font-size:8pt; font-weight:bold}
            </style>
        </head>
        <body>
            <xsl:variable name="ancillary" select="document('GeacAncillary.xml')"/>
            <div style="position:absolute; font-family:Times New Roman; font-size:96; color:#F0F0F0; z-index:-1">
	        <xsl:value-of select="$ancillary//watermark"/>
            </div>

            <div>
                <table class="disp">
                    <xsl:apply-templates select="Resource"  />
                </table>
            </div>
            <div>
            	<xsl:apply-templates select=".//CitHoldings" />
            </div>
        </body>
    </html>
</xsl:template>

<xsl:template match="Resource">
    <xsl:apply-templates select=".//LCN" />
    <xsl:apply-templates select=".//Creator" />
    <xsl:apply-templates select=".//Title" />
    <xsl:apply-templates select=".//Subject" />
    <xsl:apply-templates select=".//Edition" />
    <xsl:apply-templates select=".//Year" />
    <xsl:apply-templates select=".//Publisher" />
    <xsl:apply-templates select=".//ISBN" />
    <xsl:apply-templates select=".//ISSN" />
    <xsl:apply-templates select=".//Contributor" />
    <xsl:apply-templates select=".//NoOfTitleHolds" />
    <xsl:apply-templates select=".//URI" />
    <xsl:apply-templates select=".//URIPicture" />
    <xsl:apply-templates select=".//URIImage" />
    <xsl:apply-templates select=".//OpenUrlLink" />
</xsl:template>

<!-- wzr bibsection templates  -->

<xsl:template match="LCN">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>LCN :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Creator">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Creator :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Title">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Title :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Edition">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Edition :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Year">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Date :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Publisher">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Publisher :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="ISBN">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>ISBN :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="ISSN">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>ISSN :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Subject">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Subject :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="Contributor">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Contributor :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="NoOfTitleHolds">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>Holds :</xsl:text>
            </span>
        </td>
        <td align="left">
            <xsl:value-of select="." />
        </td>
    </tr>
</xsl:template>

<xsl:template match="URI">
    <tr>
        <td align="left" valign="top">
            <span style="color:magenta">
                <xsl:text>URI :</xsl:text>
            </span>
        </td>
        <td align="left">
	    <xsl:element name="a">
                <xsl:attribute name="href">#URL|<xsl:value-of select="." /></xsl:attribute>
		<xsl:attribute name="title">Click to select</xsl:attribute>
		<xsl:choose>
		    <xsl:when test="@Linktext">
                        <span style="color:blue"><xsl:value-of select="@Linktext"/></span>
	            </xsl:when>
		    <xsl:otherwise>
			<span style="color:blue"><xsl:value-of select="."/></span>
		    </xsl:otherwise>
		</xsl:choose>
            </xsl:element>
        </td>
    </tr>
</xsl:template>

<xsl:template match="URIPicture">
    <tr>
        <td>&#160;</td>
        <td>
            <br/>
            <xsl:element name="a">
                <xsl:attribute name="href">#URL|<xsl:value-of select="normalize-space(.)" /></xsl:attribute>
                <xsl:element name="img">
                    <xsl:attribute name="src"><xsl:value-of select="." /></xsl:attribute> 
                    <xsl:attribute name="width">20%</xsl:attribute>
                    <xsl:if test="@alt">
                        <xsl:attribute name="alt"><xsl:value-of select="@alt" /></xsl:attribute>
                        <span class="credit">
                            <br/><xsl:value-of select="@alt" />
                        </span>
                    </xsl:if>
                    <xsl:if test="@Credit">
                        <span class="credit">
                            <br/><xsl:value-of select="@Credit" />
                        </span>
                    </xsl:if>
                </xsl:element>
            </xsl:element>
        </td>
    </tr>
</xsl:template>

<xsl:template match="URIImage">
    <tr>
        <td>&#160;</td>
        <td>
            <br/>
            <xsl:variable name="linkpath">
                <xsl:choose>
                    <xsl:when test="@LinkPath">
                        <xsl:value-of select="normalize-space(@LinkPath)" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="normalize-space(.)" />
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:element name="a">
                <xsl:attribute name="href">#URL|<xsl:value-of select="$linkpath" /></xsl:attribute>
                <xsl:element name="img">
                    <xsl:attribute name="src"><xsl:value-of select="normalize-space(.)" /></xsl:attribute> 
                    <xsl:attribute name="width">20%</xsl:attribute>
                    <xsl:if test="@ImageDesc">
                        <xsl:attribute name="alt"><xsl:value-of select="@ImageDesc" /></xsl:attribute>
                    </xsl:if>
                </xsl:element>
            </xsl:element>
        </td>
    </tr>
</xsl:template>

<xsl:template match="OpenUrlLink">
    <tr>
        <td>&#160;</td>
        <td>
            <br/>
            <xsl:variable name="linkpath">
                <xsl:choose>
                    <xsl:when test="@LinkPath">
                        <xsl:value-of select="normalize-space(@LinkPath)" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="normalize-space(.)" />
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:element name="a">
                <xsl:attribute name="href">#URL|<xsl:value-of select="$linkpath" /></xsl:attribute>
                <xsl:element name="img">
                    <xsl:attribute name="src"><xsl:value-of select="normalize-space(.)" /></xsl:attribute> 
                    <xsl:attribute name="width">20%</xsl:attribute>
                    <xsl:if test="@ImageDesc">
                        <xsl:attribute name="alt"><xsl:value-of select="@ImageDesc" /></xsl:attribute>
                    </xsl:if>
                </xsl:element>
            </xsl:element>
        </td>
    </tr>
</xsl:template>

<xsl:template match="CitHoldings">
    <br /><hr />
    <xsl:if test=".//CitHoldingsByLoc">
        <xsl:choose>
            <xsl:when test=".//HeldAt">
	        <table class="tabledisp" width="100%" border="1">
		    <caption>  &#160; </caption>   
		    <thead class="tabledisp" style="height:20; align:center; background-color:silver">
		        <tr>
		            <th width="40%">Location</th>
			    <th width="20%">Call Number</th>
			    <th width="40%">Statement</th>
		        </tr>
		    </thead>
		    <xsl:for-each select=".//HeldAt/HoldingsByLoc">
		        <tr>               
                            <td align="left" valign="top">                     
                                <table class="tabledisp" cellpadding="5">                                            
                                    <tr>
                                        <xsl:if test="normalize-space(.//@ImagePath)">
                                            <td>                                           
                                                <xsl:call-template name="LocationMap">
                                                    <xsl:with-param name="imagepath" select="normalize-space(.//@ImagePath)" />
                                                    <xsl:with-param name="imagedesc" select=".//@ImageDesc" />
                                                    <xsl:with-param name="linkpath" select="normalize-space(.//@LinkPath)" />
                                                </xsl:call-template>                         
                                            </td>
                                        </xsl:if>
                                        <td>
                                            <xsl:choose>
                                                <xsl:when test=".//HoldingKeys">
                                                    <xsl:element name="a">
                                                        <xsl:attribute name="href">#itemkey|<xsl:value-of select=".//HoldingKeys" /></xsl:attribute>
				                        <xsl:attribute name="title">Click to select</xsl:attribute>
                                                        <span style="color:black">
			                                    <xsl:value-of select="normalize-space(concat(.//@Institution, ' ',.//@Sublocation,' ',.//@Collection))" />
                                                        </span>
                                                    </xsl:element>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <span style="color:black">
			                                <xsl:value-of select="normalize-space(concat(.//@Institution, ' ',.//@Sublocation,' ',.//@Collection))" />
                                                    </span>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </td>
                                    </tr>
                                </table>
                            </td>
		            <td align="left" valign="top">		    
		                <xsl:value-of select="normalize-space(concat(.//@CallNumberPrefix,' ',.//@CallNumber,' ',.//@CallNumberSuffix,' ',.//@CopyNumber))" /><br/>
		            </td>         
			    <td align="left" valign="top">
			        <xsl:choose>
				    <xsl:when test=".//HoldingSummary/Statement">
				        <xsl:for-each select=".//HoldingSummary/Statement">
					    <xsl:value-of select="." /><br/>
					    <xsl:choose>		    	            
				                <xsl:when test="@StatementLastRecd">
						    <span style="color:blue">
					                <xsl:value-of select="@StatementLastRecd" /><br/><br/>
					            </span>
						</xsl:when>
					    </xsl:choose>
				        </xsl:for-each>
				    </xsl:when>
				    <xsl:when test="HeldURI">
				        <xsl:for-each select="HeldURI">
					    <xsl:element name="a">
					        <xsl:attribute name="href">#URL|<xsl:value-of select="normalize-space(.)" /></xsl:attribute>
						<xsl:attribute name="title">Click to select</xsl:attribute>
						<xsl:choose>
					        <xsl:when test="@Linktext">
					            <span style="color:blue"><xsl:value-of select="@Linktext"/></span>
					        </xsl:when>
					        <xsl:otherwise>
						    <span style="color:blue"><xsl:value-of select="."/></span>
					        </xsl:otherwise>
					        </xsl:choose>
						<br/><br/>
					    </xsl:element>
				        </xsl:for-each>
				    </xsl:when>
				    <xsl:otherwise>
				        <xsl:text>&#160;</xsl:text>
				    </xsl:otherwise>
				</xsl:choose>
			    </td>
			</tr>
	            </xsl:for-each>
		</table>
            </xsl:when>
            <!-- Single Part Display -->
            <xsl:otherwise>
                <table class="tabledisp" width="100%" border="1">
		    <caption>  &#160; </caption>   
		    <thead class="tabledisp" style="height:20; align:center; background-color:silver">
		        <tr>
			    <th width="35%">Location</th>
			    <th width="35%">Call Number</th>
			    <th width="10%">Avail/Own</th>		    
			    <th width="20%">URI</th>		    
			</tr>
		    </thead>
                    <xsl:for-each select="CitHoldingsByLoc">
		        <tr>
			    <td align="left" valign="top">
                                <table class="tabledisp" cellpadding="5">                                            
                                    <tr>
                                        <xsl:if test="normalize-space(.//@ImagePath)">
                                            <td>                                          
                                                <xsl:call-template name="LocationMap">
                                                    <xsl:with-param name="imagepath" select="normalize-space(.//@ImagePath)" />
                                                    <xsl:with-param name="imagedesc" select=".//@ImageDesc" />
                                                    <xsl:with-param name="linkpath" select="normalize-space(.//@LinkPath)" />
                                                </xsl:call-template>  
                                            </td>
                                        </xsl:if>
                                        <td>
                                            <xsl:choose>
                                                <xsl:when test=".//CitHoldingKeys">
                                                    <xsl:element name="a">
                                                        <xsl:attribute name="href">#itemkey|<xsl:value-of select=".//CitHoldingKeys" /></xsl:attribute>
                                                        <xsl:attribute name="title">Click to select</xsl:attribute>
                                                        <span style="color:black">
	                                                    <xsl:value-of select="normalize-space(concat(.//@CitInstitution, ' ',.//@CitSublocation,' ',.//@CitCollection))" /><br/>
                                                        </span>
                                                    </xsl:element>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <span style="color:black">
	                                                <xsl:value-of select="normalize-space(concat(.//@CitInstitution, ' ',.//@CitSublocation,' ',.//@CitCollection))" /><br/>
                                                    </span>
				                </xsl:otherwise>
                                            </xsl:choose>
                                        </td>
                                    </tr>
                                </table>
                            </td>
			    <td align="left" valign="top">
                                <xsl:value-of select="normalize-space(concat(.//@CitCallNumber,' '))" /><br/>
                            </td>			    
			    <td align="center" valign="top">
				<xsl:value-of select=".//CitHoldingAvailOwnCnt" />
			    </td>
			    <td>
			        <xsl:choose>
				    <xsl:when test="CitLocationURI">
				        <xsl:element name="a">
					    <xsl:attribute name="href">#URL|<xsl:value-of select="normalize-space('CitLocationURI')" /></xsl:attribute>
					    <xsl:attribute name="title">Click to select</xsl:attribute>
					    <span style="color:blue">
					        <xsl:value-of select="normalize-space('CitLocationURI')" />
					    </span>
					</xsl:element>
				    </xsl:when>
				    <xsl:otherwise>
				        <b><xsl:text>&#160;</xsl:text></b>
				    </xsl:otherwise>
				</xsl:choose>
			    </td>
		        </tr>
                    </xsl:for-each>
	        </table>
            </xsl:otherwise> 
        </xsl:choose>
    </xsl:if>
</xsl:template>

<xsl:template name="LocationMap">
    <xsl:param name="imagepath" />
    <xsl:param name="imagedesc" />
    <xsl:param name="linkpath" />
    <xsl:variable name="linklocation">
        <xsl:choose>
            <xsl:when test="$linkpath">
                <xsl:value-of select="$linkpath" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$imagepath" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:element name="a">
        <xsl:attribute name="href">#URL|<xsl:value-of select="$linklocation" /></xsl:attribute>
        <xsl:element name="img">
            <xsl:attribute name="src"><xsl:value-of select="$imagepath" /></xsl:attribute> 
            <!-- <xsl:attribute name="width">20%</xsl:attribute> -->
            <xsl:if test="$imagedesc">
                <xsl:attribute name="alt"><xsl:value-of select="$imagedesc" /></xsl:attribute>
            </xsl:if>
        </xsl:element>
    </xsl:element>
</xsl:template>

</xsl:stylesheet>