<?xml version="1.0" ?> 
<!-- Copyright 2001 Geac Canada Limited                        -->
<!-- created for Geac Geos2 product on January 23, 2001.       -->
<!--                  last modified on April 17, 2002.         -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" version="4.0" />

<xsl:template match="/">
    <html>
        <head>
            <title>Detail Display of XML document</title>
            <style>
                body {background-image:url("BooksOutline.gif"); background-position:center center; background-repeat:no-repeat; background-attachment:fixed}
                .disp {color:black; font-family:"Arial Unicode MS"; font-size:12pt; font-weight:bold}
                .att {color:navy}
                .att_value {color:green}
                .credit {color:green; font-family:"Arial Unicode MS"; font-size:8pt; font-weight:bold}
            </style>
        </head>
        <body>
            <xsl:variable name="ancillary" select="document('GeacAncillary.xml')"/>
            <div style="position:absolute; font-family:Times New Roman; font-size:96; color:#F0F0F0; z-index:-1">
	        <xsl:value-of select="$ancillary//watermark"/>
            </div>

            <div>
                <table class="disp">
                    <xsl:apply-templates />       
                </table>
            </div>
        </body>
    </html>
</xsl:template>

<xsl:template match="*">
    <tr>
        <td align="right" valign="top">                             
            <xsl:if test="@* or child::text()">                  
                <span style="color:magenta; z-index:1">
                    <xsl:value-of select="name(.)" /> 
                    <xsl:text> : </xsl:text>
                </span>
            </xsl:if>
        </td>
        <td>
            <xsl:if test="@*">
                <xsl:apply-templates select="@*" />
            </xsl:if>
            <xsl:choose>
                <xsl:when test="@*">
                    <xsl:apply-templates select="node()">
                        <xsl:with-param name="info" select="@alt" />
                        <xsl:with-param name="attrib" select="true()" />
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="node()">
                        <xsl:with-param name="attrib" select="false()" />
                    </xsl:apply-templates>
                </xsl:otherwise>
            </xsl:choose>
        </td>      
    </tr>
</xsl:template>

<xsl:template match="@*" xml:space="preserve">
    <span class="att" style="z-index:1">
        <xsl:value-of select="name(.)" />
        <span style="z-index:1">=</span>
    </span>
    <xsl:variable name="value" select="." />
    <xsl:choose>
        <xsl:when test="string-length($value)>0">
            <xsl:text>"</xsl:text>
            <xsl:choose>
                <xsl:when test="starts-with($value,'\\') or starts-with($value,'http://') or starts-with($value,'file://') or starts-with($value,'ftp://')">
                    <xsl:call-template name="create-url">
                        <xsl:with-param name="url-link" select="$value" />
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <span class="att_value" style="z-index:1"><xsl:value-of select="$value" /></span>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:text>"</xsl:text>
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>""</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#160;&#160;</xsl:text>
</xsl:template>

<xsl:template match="text()">
    <xsl:param name="info" />
    <xsl:param name="attrib" />
    <xsl:if test="boolean($attrib)"><br/></xsl:if>
    <xsl:variable name="txtdata"><xsl:value-of select="normalize-space(.)" /></xsl:variable>
    <xsl:choose>
        <xsl:when test="starts-with($txtdata,'\\') or starts-with($txtdata,'http://') or starts-with($txtdata,'file://') or starts-with($txtdata,'ftp://')">
            <xsl:call-template name="create-url">
                <xsl:with-param name="url-link" select="." />
            </xsl:call-template>
            <xsl:if test="contains(.,'.jpg') or contains(.,'.gif')">
                <xsl:call-template name="show-image">
                    <xsl:with-param name="image" select="." />
                    <xsl:with-param name="info" select="$info" />
                </xsl:call-template>
            </xsl:if>
        </xsl:when>
        <xsl:otherwise>
            <span style="z-index:1"><xsl:value-of select="." /></span>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="create-url">
    <xsl:param name="url-link" />
    <xsl:element name="a">
        <xsl:attribute name="href"><xsl:value-of select="$url-link" /></xsl:attribute>
        <span style="color:blue"><xsl:value-of select="$url-link" /></span>
    </xsl:element>
</xsl:template>

<xsl:template name="show-image">
    <xsl:param name="image" />
    <xsl:param name="info" />
    <br/><br/>
    <xsl:element name="a">
        <xsl:attribute name="href"><xsl:value-of select="$image" /></xsl:attribute>
        <xsl:element name="img">
            <xsl:attribute name="src"><xsl:value-of select="$image" /></xsl:attribute>
            <xsl:attribute name="width">20%</xsl:attribute>
            <xsl:if test="$info">
                <xsl:attribute name="alt"><xsl:value-of select="$info" /></xsl:attribute>
                <br/><span class="credit"><xsl:value-of select="$info" /></span><br/>            
            </xsl:if>
        </xsl:element>
    </xsl:element>
    <br/>
</xsl:template>
</xsl:stylesheet>
